/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.fideicomiso;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.PagoLocalExterior;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.Beneficiario;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.Fideicomiso;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BeneficioRetencion
extends ObjetoModeloSucesorValidableAnotado<Fideicomiso>
implements InformacionEditable<BeneficioRetencion>,
Importable {
    private static final String EL_ANIO_EN_QUE_SE_GENERARON_LAS_UTILIDADES_ATRIBUIBLES_AL_DIVIDENDO = "El a\u00f1o en que se generaron las utilidades atribuibles al dividendo ";
    private static final long serialVersionUID = 5818091714139903943L;
    public static final String C_MONTO_BENEFICIO_INDIVIDUAL = "montoBeneficioIndividual";
    public static final String C_PORCENTAJE_RETENCION = "porcentajeRetencion";
    public static final String C_MONTO_RETENCION_RENTA = "montoRentencionRenta";
    public static final String C_PARTE_RELACIONADA_REC = "parteRelacionadaRec";
    public static final String C_IMP_RENT_SOC = "parteRelacionadaRec";
    public static final String C_ANIO_DIV = "anioDiv";
    public static final String C_FECHA_DIV = "fechaDiv";
    private static final String M_BENF_IND = "Monto Beneficio Individual";
    private static final String M_PORC_RET = "Porcentaje de Retenci\u00f3n";
    private static final String VALOR = "El valor ";
    private static final String PLANTILLA = "El valor %s es diferente al valor calculado por el sistema %s";
    private static final String IMP_RENT_SOC = "Impuesto a la Renta correspondiente al Dividendo";
    private Beneficiario beneficiario = new Beneficiario();
    private PagoLocalExterior pagoLocalExterior;
    @NotNull(message="Debe ingresar el valor de Monto Beneficio Individual")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Monto Beneficio Individual debe ser 12 enteros y 2 decimales. ")
    private String montoBeneficioIndividual;
    @NotNull(message="Debe ingresar el valor de Porcentaje de Retenci\u00f3n")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Porcentaje de Retenci\u00f3n debe ser 12 enteros y 2 decimales. ")
    private String porcentajeRetencion;
    @NotNull(message="Debe ingresar el valor de Valor Retenido Renta")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El Monto de Retenci\u00f3n  debe ser 12 enteros y 2 decimales. ")
    private String montoRentencionRenta;
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Impuesto a la Renta correspondiente al Dividendo debe ser 12 enteros y 2 decimales. ")
    private String impRentSoc;
    @Pattern(regexp="[0-9]*", message="El a\u00f1o en que se generaron las utilidades atribuibles al dividendo  debe ser solo n\u00fameros. ")
    private String anioGerUtilDiv;
    private Date fechaPagoDiv;
    private boolean parteRelacionada;
    private BigDecimal montoRentencionRentaCalculado;

    public BeneficioRetencion() {
        this.beneficiario.setPropietario((ObjetoModelo)this);
        this.pagoLocalExterior = new PagoLocalExterior();
        this.pagoLocalExterior.setPropietario((ObjetoModelo)this);
        this.montoBeneficioIndividual = "0.00";
        this.porcentajeRetencion = "0.00";
        this.montoRentencionRenta = "0.00";
        this.impRentSoc = "0.00";
        this.montoRentencionRentaCalculado = new BigDecimal("0.00");
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        resultado = this.getBeneficiario().validar();
        if (!resultado.esEstadoExitoso()) {
            return resultado;
        }
        if (!this.validarMontoBeneficioIndividual(resultado).esEstadoExitoso()) {
            return resultado;
        }
        if (!this.validarPorcentajeRetencion(resultado).esEstadoExitoso()) {
            return resultado;
        }
        if (!this.validarMontoRetencion(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarFechaRegistro(resultado).esEstadoExitoso()) {
            return resultado;
        }
        if (!this.validarAnioDividendo(resultado).esEstadoExitoso()) {
            return resultado;
        }
        if (resultado.esEstadoExitoso() && !(resultado = this.getPagoLocalExterior().validar()).esEstadoExitoso()) {
            return resultado;
        }
        return resultado.esEstadoExitoso() ? resultado.pasarValidacion() : resultado;
    }

    public BeneficioRetencion crearCopiaEdicion() {
        BeneficioRetencion copia = new BeneficioRetencion();
        copia.setMontoBeneficioIndividual(this.montoBeneficioIndividual);
        copia.setPorcentajeRetencion(this.porcentajeRetencion);
        copia.setMontoRentencionRenta(this.montoRentencionRenta);
        copia.setParteRelacionada(this.parteRelacionada);
        copia.setImpRentSoc(this.impRentSoc);
        copia.setFechaPagoDiv(this.fechaPagoDiv);
        copia.setAnioGerUtilDiv(this.anioGerUtilDiv);
        copia.setPropietario((ObjetoModelo)((Fideicomiso)this.propietario));
        copia.setImpRentSoc(this.impRentSoc);
        copia.setPagoLocalExterior(this.pagoLocalExterior.crearCopiaEdicion());
        copia.getPagoLocalExterior().setPropietario((ObjetoModelo)copia);
        copia.setBeneficiario(this.beneficiario.crearCopiaEdicion());
        copia.getBeneficiario().setPropietario((ObjetoModelo)copia);
        return copia;
    }

    public void actualizarInformacion(BeneficioRetencion copiaEdicion) {
        this.setMontoBeneficioIndividual(copiaEdicion.getMontoBeneficioIndividual());
        this.setPorcentajeRetencion(copiaEdicion.getPorcentajeRetencion());
        this.setMontoRentencionRenta(copiaEdicion.getMontoRentencionRenta());
        this.setPagoLocalExterior(copiaEdicion.getPagoLocalExterior());
        this.setBeneficiario(copiaEdicion.getBeneficiario());
        this.setParteRelacionada(copiaEdicion.parteRelacionada);
        this.setImpRentSoc(copiaEdicion.getImpRentSoc());
        this.setFechaPagoDiv(copiaEdicion.getFechaPagoDiv());
        this.setAnioGerUtilDiv(copiaEdicion.getAnioGerUtilDiv());
    }

    protected void validacionAnotadaExitosa() {
        this.calcularMontoRetencionRenta();
    }

    private ResultadoValidacion validarMontoBeneficioIndividual(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getMontoBeneficioIndividual()).add(((Fideicomiso)this.getPropietario()).getTotalBeneficioRetencionIndividual()).compareTo(Util.getBigDecimal(((Fideicomiso)this.getPropietario()).getMontoBeneficioTotal())) == 1) {
            return resultado.fallarValidacion("El valor Monto del Beneficio Individual no puede ser mayor al valor monto beneficio total");
        }
        return resultado;
    }

    private ResultadoValidacion validarPorcentajeRetencion(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getPorcentajeRetencion()).compareTo(Constantes.CIEN) == 1) {
            return resultado.fallarValidacion("El valor Porcentaje de Retenci\u00f3n no puede ser mayor a 100");
        }
        return resultado;
    }

    private ResultadoValidacion validarMontoRetencion(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getMontoRentencionRenta()).compareTo(this.montoRentencionRentaCalculado) != 0) {
            if (Util.isMargenErrorMasMenos(this.montoRentencionRentaCalculado, this.getMontoRentencionRenta(), Constantes.MARGEN_ERROR)) {
                return resultado.pasarValidacionAdvertencia(String.format(PLANTILLA, "Monto de Retenci\u00f3n", this.montoRentencionRentaCalculado.toString()));
            }
            return resultado.fallarValidacion(String.format(PLANTILLA, "Monto de Retenci\u00f3n", this.montoRentencionRentaCalculado.toString()));
        }
        return resultado;
    }

    private void calcularMontoRetencionRenta() {
        this.montoRentencionRentaCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoBeneficioIndividual()), Util.getBigDecimal(this.getPorcentajeRetencion()));
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        if (Util.existeElementoImportar(elemento, "pagoExterior")) {
            this.getPagoLocalExterior().importar(elemento, null);
        }
        NodeList valorList = elemento.getElementsByTagName("individualF");
        Element eValor = (Element)valorList.item(0);
        this.montoBeneficioIndividual = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("porRetF");
        eValor = (Element)valorList.item(0);
        this.porcentajeRetencion = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("valorRetF");
        eValor = (Element)valorList.item(0);
        this.montoRentencionRenta = eValor.getTextContent().trim();
        if (Util.existeElementoImportar(elemento, "fechaPagoDiv")) {
            valorList = elemento.getElementsByTagName("fechaPagoDiv");
            eValor = (Element)valorList.item(0);
            this.setFechaPagoDiv(Util.importarFecha(eValor));
        }
        if (Util.existeElementoImportar(elemento, "imRentaSoc")) {
            valorList = elemento.getElementsByTagName("imRentaSoc");
            eValor = (Element)valorList.item(0);
            this.impRentSoc = eValor.getTextContent().trim();
        }
        if (Util.existeElementoImportar(elemento, "anioUtDiv")) {
            valorList = elemento.getElementsByTagName("anioUtDiv");
            eValor = (Element)valorList.item(0);
            this.anioGerUtilDiv = eValor.getTextContent().trim();
        }
        return this;
    }

    private ResultadoValidacion validarFechaRegistro(ResultadoValidacion resultado) {
        if (this.fechaPagoDiv != null && !Util.isFechaMenorIgualPeriodoMesAnio(this.getFechaPagoDiv(), ((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado())) {
            return resultado.fallarValidacion(String.format("La fecha de %s debe ser %s a la fecha del per\u00edodo informado", "Pago del Dividendo", "menor o igual"));
        }
        return resultado;
    }

    private ResultadoValidacion validarAnioDividendo(ResultadoValidacion resultado) {
        if (this.anioGerUtilDiv != null && !Util.isAnioMenorIgualPeriodo(this.getAnioGerUtilDiv(), ((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado())) {
            return resultado.fallarValidacion("El a\u00f1o en que se generaron las utilidades atribuibles al dividendo  debe ser solo n\u00fameros. ");
        }
        return resultado;
    }

    public Beneficiario getBeneficiario() {
        return this.beneficiario;
    }

    public PagoLocalExterior getPagoLocalExterior() {
        return this.pagoLocalExterior;
    }

    public String getMontoBeneficioIndividual() {
        return this.montoBeneficioIndividual;
    }

    public String getPorcentajeRetencion() {
        return this.porcentajeRetencion;
    }

    public String getMontoRentencionRenta() {
        return this.montoRentencionRenta;
    }

    public void setBeneficiario(Beneficiario beneficiario) {
        this.beneficiario = beneficiario;
    }

    public void setPagoLocalExterior(PagoLocalExterior pagoLocalExterior) {
        this.pagoLocalExterior = pagoLocalExterior;
    }

    public void setMontoBeneficioIndividual(String montoBeneficioIndividual) {
        String oldValue = this.montoBeneficioIndividual;
        this.montoBeneficioIndividual = montoBeneficioIndividual;
        this.firePropertyChange(C_MONTO_BENEFICIO_INDIVIDUAL, oldValue, this.montoBeneficioIndividual);
    }

    public void setPorcentajeRetencion(String porcentajeRetencion) {
        String oldValue = this.porcentajeRetencion;
        this.porcentajeRetencion = porcentajeRetencion;
        this.firePropertyChange(C_PORCENTAJE_RETENCION, oldValue, this.porcentajeRetencion);
    }

    public void setMontoRentencionRenta(String montoRentencionRenta) {
        String oldValue = this.montoRentencionRenta;
        this.montoRentencionRenta = montoRentencionRenta;
        this.firePropertyChange(C_MONTO_RETENCION_RENTA, oldValue, this.montoRentencionRenta);
    }

    public boolean isParteRelacionada() {
        return this.parteRelacionada;
    }

    public String getParteRelacionada() {
        return this.parteRelacionada ? "SI" : "NO";
    }

    public void setParteRelacionada(boolean parteRelacionada) {
        boolean oldValue = this.parteRelacionada;
        this.parteRelacionada = parteRelacionada;
        this.firePropertyChange("parteRelacionadaRec", oldValue, this.parteRelacionada);
    }

    public String getImpRentSoc() {
        return this.impRentSoc;
    }

    public void setImpRentSoc(String impRentSoc) {
        String oldValue = this.impRentSoc;
        this.impRentSoc = impRentSoc;
        this.firePropertyChange("parteRelacionadaRec", oldValue, this.impRentSoc);
    }

    public Date getFechaPagoDiv() {
        return this.fechaPagoDiv;
    }

    public void setFechaPagoDiv(Date fechaPagoDiv) {
        Date oldValue = this.fechaPagoDiv;
        this.fechaPagoDiv = fechaPagoDiv;
        this.firePropertyChange(C_FECHA_DIV, oldValue, this.fechaPagoDiv);
    }

    public String getAnioGerUtilDiv() {
        return this.anioGerUtilDiv;
    }

    public void setAnioGerUtilDiv(String anioGerUtilDiv) {
        String oldValue = this.anioGerUtilDiv;
        this.anioGerUtilDiv = anioGerUtilDiv;
        this.firePropertyChange(C_ANIO_DIV, oldValue, this.anioGerUtilDiv);
    }
}

